#!/bin/bash
# start rrd-tool for haussteuerung
# create rrd-database from sensors file
dsn=./database.rrd
airtemp=''
airmoist=''
drewpoint=''
timeoffset=''   #need to offset the times read by file ,to the time generated the database
interval=16    # messintervall sec
unknown=`echo 2*$interval|bc` # unknown value sec
unkown_RRA=0.5   # max 50% unkown values
day_points=`echo 24*3600/$interval|bc`   # anzahl der Messpunkte pro tag
week_points_start=`echo 10*60/$interval|bc`  # number of intervals per 10 minutes
week_points_end=`echo 24*7*6|bc`             # number of 10 minutes per week 
now=$(date "+%a %x")
case "$1" in
    update)
            cat ./sensors | while read LINE
            do 
              echo "${LINE}"
              x=`echo "$LINE" |awk '{ print $1" "$2}'| tr '.' ' ' `
              x=`echo "$x"|awk '{print $2"/"$3"/"$1" "$4}'` 
              dateconv=`date -d "$x" +'%s'`
              sensor=`echo "$LINE" |awk '{ print $4" "$5}'`
              if [ "$sensor" == 'Sensor 16' ]
               then
                airtemp=`echo "$LINE" |awk '{ print $7}'`
              fi
              if [ "$sensor" == 'Sensor 10' ]
               then
                airmoist=`echo "$LINE" |awk '{ print $7}'`
              fi
              if [ "$sensor" == 'Sensor 99' ]
               then
                drewpoint=`echo "$LINE" |awk '{ print $7}'`
              fi

              if [ -n "$airtemp" ] && [ -n "$airmoist" ] && [ -n "$drewpoint" ]
               then
                if [ -z "$timeoffset" ]
                  then
                  timeoffset=`rrdtool info $dsn|grep last_update|awk '{ print $3}'`
                  timeoffset=`echo $timeoffset - $dateconv + 1|bc` 
                fi
                newtime=`echo $dateconv + $timeoffset|bc`
                rrdtool update $dsn $newtime:$airtemp:$airmoist:$drewpoint
                airtemp=''
                airmoist=''
                drewpoint=''
               fi
            done
 
            ;;
     graph)
            rrdtool graph rrdgraph.png \
              --height=200 --width=750 \
              -y 2:1 --vertical-label "[deg C]" \
              -s -10m  -e -1s \
              DEF:airtemp=$dsn:airtemp:AVERAGE \
              DEF:airmoist=$dsn:airmoist:AVERAGE \
              DEF:drewpoint=$dsn:drewpoint:AVERAGE \
              LINE1:airtemp#0000FF:"Air temperature [deg C]" \
              LINE1:airmoist#CC6600:"Air moist [%]\n" \
              LINE1:drewpoint#00CC66:"Drewpoint [deg C]\n" \
              GPRINT:airtemp:LAST:"Current Temp\:%8.2lf %s" \
              GPRINT:airtemp:AVERAGE:"Average Temp\:%8.2lf %s" \
              GPRINT:airtemp:MIN:"Min Temp\:%8.2lf %s" \
              GPRINT:airtemp:MAX:"Max Temp\:%8.2lf %s\n" \
              GPRINT:airmoist:LAST:"Current Moist\:%8.2lf %s" \
              GPRINT:airmoist:AVERAGE:"Average Moist\:%8.2lf %s" \
              GPRINT:airmoist:MIN:"Min Moist\:%8.2lf %s" \
              GPRINT:airmoist:MAX:"Max Moist\:%8.2lf %s\n" \
              GPRINT:drewpoint:LAST:"Current Drewpoint\:%8.2lf %s" \
              GPRINT:drewpoint:AVERAGE:"Average Drewpoint\:%8.2lf %s" \
              GPRINT:drewpoint:MIN:"Min Drewpoint\:%8.2lf %s" \
              GPRINT:drewpoint:MAX:"Max Drewpoint\:%8.2lf %s\n" \
              COMMENT:"  Created at $now"
            ;;
    create)
            rm $dsn
            rrdtool create $dsn --start N --step $interval \
             DS:airtemp:GAUGE:$unknown:U:U \
             DS:airmoist:GAUGE:$unknown:U:U \
             DS:drewpoint:GAUGE:$unknown:U:U \
             RRA:AVERAGE:$unkown_RRA:1:$day_points \
             RRA:AVERAGE:$unkown_RRA:$week_points_start:$week_points_end
            ;;
    fetch)
            rrdtool fetch $dsn AVERAGE -r $interval -s -1d -e -1s
            ;;
    start)
            ;;
   stop) 
           ;;
   restart)
            ;;
        *)
          echo "Error no start,stop,update,fetch,graph or create parameter given"
          exit 1
          ;;
    esac
