#!/bin/bash
# generated script for rrd from data-Input
#
dsn=./database.rrd
interval=16    # messintervall sec
now=$(date +%a %x)
case "$1" in
    create)
          # create a rrd-Database with Input-Variables
          rrdtool create ./database.rrd --start N --step 16 \
           DS:Sensor2:GAUGE:32:U:U \ 
           DS:Sensor1:GAUGE:32:U:U \ 
           DS:Sensor3:GAUGE:32:U:U \ 
           DS:Sensor7:GAUGE:32:U:U \ 
           DS:Sensor5:GAUGE:32:U:U \ 
           DS:Sensor4:GAUGE:32:U:U \ 
           DS:Sensor9:GAUGE:32:U:U \ 
           DS:Sensor10:GAUGE:32:U:U \ \
           RRA:AVERAGE:0.5:1:5400 \
           RRA:AVERAGE:0.5:37:1008
          ;;
    update)
           sleep $interval
           # update rrd-Database with Input-Variables
           rrdtool update $dsn N:Sensor2:Sensor1:Sensor3:Sensor7:Sensor5:Sensor4:Sensor9:Sensor10
          ;;
    graph)
         # graph from a rrd-Database with Input-Variables
          rrdtool graph rrdgraph.png \ 
              --height=200 --width=750 \ 
              -y 2:1 --vertical-label "[deg C]" \
              -s -10m  -e -1s \ 
           DEF:Sensor2=$dsn:Sensor2:AVERAGE \ 
           DEF:Sensor1=$dsn:Sensor1:AVERAGE \ 
           DEF:Sensor3=$dsn:Sensor3:AVERAGE \ 
           DEF:Sensor7=$dsn:Sensor7:AVERAGE \ 
           DEF:Sensor5=$dsn:Sensor5:AVERAGE \ 
           DEF:Sensor4=$dsn:Sensor4:AVERAGE \ 
           DEF:Sensor9=$dsn:Sensor9:AVERAGE \ 
           DEF:Sensor10=$dsn:Sensor10:AVERAGE \ 
           LINE1:Sensor2#0000FF:"Sensor2" \ 
           LINE1:Sensor1#CC6600:"Sensor1" \ 
           LINE1:Sensor3#FF4500:"Sensor3" \ 
           LINE1:Sensor7#1E90FF:"Sensor7" \ 
           LINE1:Sensor5#FF0000:"Sensor5" \ 
           LINE1:Sensor4#FF1493:"Sensor4" \ 
           LINE1:Sensor9#FF82AB:"Sensor9" \ 
           LINE1:Sensor10#00F5FF:"Sensor10" \
           GPRINT:Sensor2:LAST:"Sensor2" \ 
           GPRINT:Sensor1:LAST:"Sensor1" \ 
           GPRINT:Sensor3:LAST:"Sensor3" \ 
           GPRINT:Sensor7:LAST:"Sensor7" \ 
           GPRINT:Sensor5:LAST:"Sensor5" \ 
           GPRINT:Sensor4:LAST:"Sensor4" \ 
           GPRINT:Sensor9:LAST:"Sensor9" \ 
           GPRINT:Sensor10:LAST:"Sensor10" \ 
           GPRINT:Sensor2:AVERAGE:"Sensor2" \ 
           GPRINT:Sensor1:AVERAGE:"Sensor1" \ 
           GPRINT:Sensor3:AVERAGE:"Sensor3" \ 
           GPRINT:Sensor7:AVERAGE:"Sensor7" \ 
           GPRINT:Sensor5:AVERAGE:"Sensor5" \ 
           GPRINT:Sensor4:AVERAGE:"Sensor4" \ 
           GPRINT:Sensor9:AVERAGE:"Sensor9" \ 
           GPRINT:Sensor10:AVERAGE:"Sensor10" \ 
           GPRINT:Sensor2:MIN:"Sensor2" \ 
           GPRINT:Sensor1:MIN:"Sensor1" \ 
           GPRINT:Sensor3:MIN:"Sensor3" \ 
           GPRINT:Sensor7:MIN:"Sensor7" \ 
           GPRINT:Sensor5:MIN:"Sensor5" \ 
           GPRINT:Sensor4:MIN:"Sensor4" \ 
           GPRINT:Sensor9:MIN:"Sensor9" \ 
           GPRINT:Sensor10:MIN:"Sensor10" \ 
           GPRINT:Sensor2:MAX:"Sensor2" \ 
           GPRINT:Sensor1:MAX:"Sensor1" \ 
           GPRINT:Sensor3:MAX:"Sensor3" \ 
           GPRINT:Sensor7:MAX:"Sensor7" \ 
           GPRINT:Sensor5:MAX:"Sensor5" \ 
           GPRINT:Sensor4:MAX:"Sensor4" \ 
           GPRINT:Sensor9:MAX:"Sensor9" \ 
           GPRINT:Sensor10:MAX:"Sensor10" \ 
           COMMENT:"  Created at $now"
          ;;
    start)
          ;;
    stop)
          ;;
   fetch)
          rrdtool fetch $dsn AVERAGE -r $interval -s -1d -e -1s
          ;;
        *)
          echo "Error no start,stop,update,fetch,graph or create parameter given"
          exit 1
         ;;
esac
