#!/bin/sh -x
# start rrd-tool for ping statistic
# 
dsn=./ping.rrdtool
host=localhost   #host to ping
interval=5    # messintervall sec
unknown=`echo 2*$interval|bc` # unknown value sec
unkown_RRA=0.5   # max 50% unkown values
day_points=`echo 24*3600/$interval|bc`   # anzahl der Messpunkte pro tag
week_points_start=`echo 10*60/$interval|bc`  # number of intervals per 10 minutes
week_points_end=`echo 24*7*6|bc`             # number of 10 minutes per week 
now=$(date "+%a %x")
case "$1" in
    update)
            pingtime=$(ping -c 3 -w 6 $host | grep rtt | awk -F "/" '{ print $5 }' )
            rrdtool update $dsn N:$pingtime
            sleep $interval
            dummy=`./ping-rrd.sh update`
            ;;
     graph)
              rrdtool graph ping.png  \
               -t "WAN Ping" -v "Time in ms" \
               --start="now-1d" \
               --end="now" \
               --height="120" \
               --width="440" \
               -c "BACK#000000" \
               -c "SHADEA#000000" \
               -c "SHADEB#000000" \
               -c "FONT#DDDDDD" \
               -c "CANVAS#202020" \
               -c "GRID#666666" \
               -c "MGRID#AAAAAA" \
               -c "FRAME#202020" \
               -c "ARROW#FFFFFF" \
               "DEF:ping_time=$dsn:ping:AVERAGE" \
               "CDEF:shading2=ping_time,0.98,*" "AREA:shading2#F90000:$host" \
               "GPRINT:ping_time:LAST:Last\: %5.2lf ms" \
               "GPRINT:ping_time:MIN:Min\: %5.2lf ms" \
               "GPRINT:ping_time:MAX:Max\: %5.2lf ms" \
               "GPRINT:ping_time:AVERAGE:Avg\: %5.2lf ms" \
               "CDEF:shading10=ping_time,0.90,*" "AREA:shading10#E10000" \
               "CDEF:shading15=ping_time,0.85,*" "AREA:shading15#D20000" \
               "CDEF:shading20=ping_time,0.80,*" "AREA:shading20#C30000" \
               "CDEF:shading25=ping_time,0.75,*" "AREA:shading25#B40000" \
               "CDEF:shading30=ping_time,0.70,*" "AREA:shading30#A50000" \
               "CDEF:shading35=ping_time,0.65,*" "AREA:shading35#960000" \
               "CDEF:shading40=ping_time,0.60,*" "AREA:shading40#870000" \
               "CDEF:shading45=ping_time,0.55,*" "AREA:shading45#780000" \
               "CDEF:shading50=ping_time,0.50,*" "AREA:shading50#690000" \
               "CDEF:shading55=ping_time,0.45,*" "AREA:shading55#5A0000" \
               "CDEF:shading60=ping_time,0.40,*" "AREA:shading60#4B0000" \
               "CDEF:shading65=ping_time,0.35,*" "AREA:shading65#3C0000" \
               "CDEF:shading70=ping_time,0.30,*" "AREA:shading70#2D0000" \
               "CDEF:shading75=ping_time,0.25,*" "AREA:shading75#180000" \
               "CDEF:shading80=ping_time,0.20,*" "AREA:shading80#0F0000" \
               "CDEF:shading85=ping_time,0.15,*" "AREA:shading85#000000" >/dev/null

            ;;
    create)
            rm $dsn
            rrdtool create $dsn --start N --step $interval \
             --step $interval  \
             -s 60 \
             DS:ping:GAUGE:120:0:65535 \
             RRA:AVERAGE:0.5:1:2880
            ;;
    fetch)
            rrdtool fetch $dsn AVERAGE -r $interval -s -1d -e -1h
            ;;
    start)
            ;;
   stop) 
           ;;
   restart)
            ;;
        *)
          echo "Error no start,stop,update,fetch,graph or create parameter given"
          exit 1
          ;;
    esac
