#!/bin/bash -x
# generate script for rrd from data-Input
# 
# You have to change dsn,input,sec_input,var,var1 to your needs
# sec_input and var1 is only neccessary when you need to combine to Inputs
#
dsn=./database.rrd
script=./script-rrd.sh    #generated rrd script
input=./temperatur.txt    # data-input-dataset
sec_input=./Heizungsparameter.csv # convert variable to sensorname
DS=''  
DEF=''
LINE1=''
VAL=''
n=0
# color of lines
COLOR[1]="#0000FF"   
COLOR[2]="#CC6600"
COLOR[3]="#FF4500"
COLOR[4]="#1E90FF"
COLOR[5]="#FF0000"
COLOR[6]="#FF1493"
COLOR[7]="#FF82AB"
COLOR[8]="#00F5FF"
COLOR[9]="#00FF7F"
COLOR[10]="#9B30FF"
COLOR[11]="#FFFF00"
COLOR[12]="#00FF00"
timeoffset=''   #need to offset the times read by file ,to the time generated the database
interval=16    # messintervall sec
unknown=`echo 2*$interval|bc` # unknown value sec
unkown_RRA=0.5   # max 50% unkown values
day_points=`echo 24*3600/$interval|bc`   # anzahl der Messpunkte pro tag
week_points_start=`echo 10*60/$interval|bc`  # number of intervals per 10 minutes
week_points_end=`echo 24*7*6|bc`             # number of 10 minutes per week 
now=$(date "+%a %x")
case "$1" in
    generate)
             rm $script
             echo "#!/bin/bash"  >>$script 
             echo "# generated script for rrd from data-Input" >>$script
             echo "#" >>$script
             echo "dsn=$dsn" >>$script
             echo "interval=16    # messintervall sec" >>$script
             echo "now=\$(date \"+%a %x\")" >>$script
             echo "case \"\$1\" in" >>$script
             #create
             echo "    create)" >>$script
             `./generate-rrd.sh create`
             echo "          ;;" >>$script
             #update
             echo "    update)" >>$script
             echo "           sleep \$interval" >>$script
             `./generate-rrd.sh update`
             echo "          ;;" >>$script
             #graph
             echo "    graph)" >>$script
             `./generate-rrd.sh graph`
             echo "          ;;" >>$script
             #start
             echo "    start)" >>$script
             echo "          ;;" >>$script
             #stop
             echo "    stop)" >>$script
             echo "          ;;" >>$script
             #fetch
             echo "   fetch)" >>$script
             echo "          rrdtool fetch \$dsn AVERAGE -r \$interval -s -1d -e -1s" >>$script
             echo "          ;;" >>$script
             #default
             echo "        *)" >>$script
             echo "          echo \"Error no generate,start,stop,update,fetch,graph or create parameter given\"" >>$script
             echo "          exit 1" >>$script
             echo "         ;;" >>$script
             echo "esac" >>$script

             ;;
    update)
            cat $input | (while read LINE ;
             do
               var1=`echo "$LINE" |awk '{ print $4"\";"$5";"}'`
               var=`cat $sec_input |grep $var1|awk '{ print $1}'|sed 's/\"//g'`
               if [ -n "$var" ]
                then
                 if [ -z "$VAL" ] 
                  then
                    VAL=$VAL"\$"$var
                  else
                    VAL=$VAL":\$"$var
                 fi
                fi 
             done 
             VAL=`echo -e "${VAL%?}"` #delete last character
             echo "           # update rrd-Database with Input-Variables" >>$script
             echo "           rrdtool update \$dsn N:$VAL" >>$script
             )
            ;;  
     graph)
            echo "         # graph from a rrd-Database with Input-Variables" >>$script
            echo -e "          rrdtool graph rrdgraph.png \\
              --height=200 --width=750 \\""
              -y 2:1 --vertical-label \"[deg C]\" \\""
              -s -10m  -e -1s \\" >>$script
            n=0
            cat $input | (while read LINE ;
            do 
              n=`echo $n + 1|bc`
              var1=`echo "$LINE" |awk '{ print $4"\";"$5";"}'`
              var=`cat $sec_input |grep $var1|awk '{ print $1}'|sed 's/\"//g'`
              if [ -n "$var" ]
               then
                DEF=$DEF"           DEF:$var=\$dsn:$var:AVERAGE \\"'\\n'
                LINE1=$LINE1"           LINE1:$var${COLOR[$n]}:\"$var\" \\"'\\n'
                GPRINTL=$GPRINTL"           GPRINT:$var:LAST:\"$var\\:%8.2lf %s\" \\"'\\n'
                GPRINTA=$GPRINTA"           GPRINT:$var:AVERAGE:\"$var\\:%8.2lf %s\" \\"'\\n'
                GPRINTMI=$GPRINTMI"           GPRINT:$var:MIN:\"$var\\:%8.2lf %s\" \\"'\\n'
                GPRINTMA=$GPRINTMA"           GPRINT:$var:MAX:\"$var\\:%8.2lf %s\" \\"'\\n'
               fi 
            done
             DEF=`echo -e "${DEF%?}"` #delete last  newline
             DEF=`echo -e "${DEF%?}"` #delete last \ 
             echo -e "$DEF" >>$script  
             LINE1=`echo -e "${LINE1%?}"` #delete last  newline
             echo -e "${LINE1%?}" >>$script
             GPRINTL=`echo -e "${GPRINTL%?}"` #delete last  newline
             GRPINTL=`echo -e "${GPRINTL%?}"` #delete last \ 
             echo -e "${GPRINTL%?}" >>$script 
             GPRINTA=`echo -e "${GPRINTA%?}"` #delete last  newline
             GRPINTA=`echo -e "${GPRINTA%?}"` #delete last \ 
             echo -e "${GPRINTA%?}" >>$script 
             GPRINTMI=`echo -e "${GPRINTMI%?}"` #delete last  newline
             GRPINTMI=`echo -e "${GPRINTMI%?}"` #delete last \ 
             echo -e "${GPRINTMI%?}" >>$script 
             GPRINTMA=`echo -e "${GPRINTMA%?}"` #delete last  newline
             GRPINTMA=`echo -e "${GPRINTMA%?}"` #delete last \ 
             echo -e "${GPRINTMA%?}" >>$script 
             echo "           COMMENT:\"  Created at \$now\"" >>$script
            )
            ;;
    create)
            rm $dsn
            echo "          # create a rrd-Database with Input-Variables" >>$script
            echo "          rrdtool create $dsn --start N --step $interval \\" >>$script
            cat $input | (while read LINE ;
            do 
              var1=`echo "$LINE" |awk '{ print $4"\";"$5";"}'`
              var=`cat $sec_input |grep $var1|awk '{ print $1}'|sed 's/\"//g'`
              if [ -n "$var" ]
               then
                DS=$DS"           DS:$var:GAUGE:$unknown:U:U \\"'\\n'
               fi
            done 
            echo -ne "${DS}" >>$script
            #echo -e "${DS%?}" >>$script #delete last newline
            echo -e "           RRA:AVERAGE:$unkown_RRA:1:$day_points \\" >>$script
            echo -e "           RRA:AVERAGE:$unkown_RRA:$week_points_start:$week_points_end" >>$script
            )
            ;;
    fetch)
            rrdtool fetch $dsn AVERAGE -r $interval -s -1d -e -1s
            ;;
    start)
            ;;
   stop) 
           ;;
   restart)
            ;;
        *)
          echo "Error no generate,start,stop,update,fetch,graph or create parameter given"
          exit 1
          ;;
    esac
