#!/bin/sh
#create graphic
nice -n 19 rrdtool graph ./network/eth0.png --start -129600 \
-a PNG -t "Network Interface eth0" --vertical-label "Bytes/s" -w 600 -h 100 -M \
DEF:eth0r=./network/networketh0.rrd:eth0r:AVERAGE \
DEF:eth0t=./network/networketh0.rrd:eth0t:AVERAGE \
CDEF:eth0tn=eth0t,-1,* \
VDEF:eth0ra=eth0r,AVERAGE \
VDEF:eth0rm=eth0r,MAXIMUM \
VDEF:eth0rc=eth0r,LAST \
VDEF:eth0ta=eth0t,AVERAGE \
VDEF:eth0tm=eth0t,MAXIMUM \
VDEF:eth0tc=eth0t,LAST \
COMMENT:"               Durchschnitt           Maximum          aktuell   pro Sekunde\n" \
AREA:eth0r#00dd00:"Receive " \
GPRINT:eth0ra:"%12.3lf %sb" \
GPRINT:eth0rm:"%12.3lf %sb" \
GPRINT:eth0rc:"%12.3lf %sb\n" \
AREA:eth0tn#0000ff:"Transmit" \
GPRINT:eth0ta:"%12.3lf %sb" \
GPRINT:eth0tm:"%12.3lf %sb" \
GPRINT:eth0tc:"%12.3lf %sb" > /dev/null